// AddHolidayGroup.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "AddHolidayGroup.h"
#include "AddMasterHoliday.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAddHolidayGroup dialog


CAddHolidayGroup::CAddHolidayGroup(CWnd* pParent /*=NULL*/)
	: CDialog(CAddHolidayGroup::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAddHolidayGroup)
	m_sHGDesc = _T("");
	m_sHGName = _T("");
	m_nHolCount = 0;
	m_sHolName = _T("");
	m_bEveryYear = FALSE;
	m_iHolType = 0;
	m_lDay = 0;
	m_lYear = 0;
	m_lMonth = 0;
	//}}AFX_DATA_INIT
}

CAddHolidayGroup ::CAddHolidayGroup(IApplication *pApp):CDialog(CAddHolidayGroup::IDD, NULL)
{
	pApplication = pApp;
	pHolGrp.CreateInstance(__uuidof(HolidayGroup));
	m_lDay = 0;
	m_lYear = 0;
	m_lMonth = 0;
}

void CAddHolidayGroup::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddHolidayGroup)
	DDX_Control(pDX, IDC_CMB_ACCT, m_AcctList);
	DDX_Text(pDX, IDC_HG_NAME, m_sHGName);
	DDX_Text(pDX, IDC_NAME_HOLIDAY_HG, m_sHolName);
	DDX_Check(pDX, IDC_CHECK_EVERYYEAR_HG, m_bEveryYear);
	DDX_Radio(pDX, IDC_RADIO_HOLIDAY1_HG, m_iHolType);
	DDX_Text(pDX, IDC_EDIT_DAY2, m_lDay);
	DDX_Text(pDX, IDC_EDIT_YEAR2, m_lYear);
	DDX_Text(pDX, IDC_EDIT_MONTH2, m_lMonth);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAddHolidayGroup, CDialog)
	//{{AFX_MSG_MAP(CAddHolidayGroup)
	ON_BN_CLICKED(IDC_BTN_ADD_HG, OnBtnAddHG)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddHolidayGroup message handlers

void CAddHolidayGroup::OnBtnAddHG() 
{
	UpdateData();
	HRESULT hr;
	VARIANT vMasterHolidays;
	vMasterHolidays.vt = VT_EMPTY;
	VARIANT vHolidays;
	long lCount = 0;

	pHolGrp->HolGrpName = m_sHGName.AllocSysString();

	int index = m_AcctList.GetCurSel();
	if(index<0)
	{
		AfxMessageBox(_T("Account not selected"));
		return;
	}

	CString sAcctID;
	m_AcctList.GetLBText(index,sAcctID);
	long lAcctID = _wtoi(sAcctID);
	pHolGrp->AccountID = lAcctID;
	
	
	//get the Account Name by AccountID
	//TR bstrAcctName; 
	//pplication->GetAccountNameByAcctID(lAcctID,&bstrAcctName);
	//olGrp->AccountName = bstrAcctName;

	COleSafeArray saMasterHolidays;
	COleSafeArray saHolidays;

	IMasterHoliday *pIHoliday = NULL;
	saHolidays.CreateOneDim(VT_DISPATCH,1);
	IMasterHolidayPtr	pHol;
	pHol.CreateInstance(__uuidof(MasterHoliday));
	pHol->ApplyAllYears = m_bEveryYear;
	pHol->HolidayType = m_iHolType+1;
	pHol->Name = m_sHolName.AllocSysString();
	try
	{
		pHol->Day = m_lDay;
		pHol->Month = m_lMonth;
		pHol->Year = m_lYear;
	}
	catch(CString errStr)
	{
		AfxMessageBox(errStr);
		return;
	}

	hr = pHol->QueryInterface(IID_IMasterHoliday, (void**)&pIHoliday);
	if(SUCCEEDED(hr)) //timezone query interface succeeds if start
	{
		saHolidays.PutElement(&lCount,pIHoliday);
	}
	vHolidays = saHolidays.Detach();
	long lStatus = 0;
	hr = pApplication->AddHolidayGroup(pHolGrp,vHolidays,vMasterHolidays,&lStatus);
	if (lStatus == 105)
	{
		AfxMessageBox(L"Invalid account");
		return;
	}
	if(lStatus ==801)
	{
		AfxMessageBox(L"Holiday Group Name already exists");
		return;
	}
	if(lStatus ==802)
	{
		AfxMessageBox(L"Holiday Group Name cannot be Null");
		return;
	}
	if(lStatus ==803)
	{
		AfxMessageBox(L"Holiday Group Name Length must be less than 30 characters");
		return;
	}
	if(lStatus ==804)
	{
		AfxMessageBox(L"Holiday Group must contain atleast one holiday");
		return;
	}
	if(lStatus ==805)
	{
		AfxMessageBox(L"Holiday name is invalid");
		return;
	}
	if(lStatus ==806)
	{
		AfxMessageBox(L"Holiday name length is invalid");
		return;
	}
	if(lStatus ==807)
	{
		AfxMessageBox(L"Holiday group cant contain 2 or more holidays with same name");
		return;
	}
	if(lStatus ==808)
	{
		AfxMessageBox(L"Holiday group cant contain 2 or more holidays with same date");
		return;
	}
	if (lStatus == 705)
	{
		AfxMessageBox(L"Invalid holiday date");
		return;
	}
	if (lStatus == 706)
	{
		AfxMessageBox(L"Given master holiday does not exist");
		return;
	}
	if (lStatus == 703)
	{
		AfxMessageBox(L"Invalid Holiday type");
		return;
	}
	if (lStatus == 704)
	{
		AfxMessageBox(L"Invalid definition for every year");
		return;
	}
	if (lStatus == 1)
	{
		AfxMessageBox(L"Holiday group Addition Failed");
		return;
	}

	else
	{
		AfxMessageBox(L"Holiday group Addition succeeded");
		CDialog::OnOK();
	}
}

BOOL CAddHolidayGroup::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CAddHolidayGroup::LoadAccounts()
{
	_variant_t vAccounts;
	vAccounts.Clear();
	pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
	
	if(vAccounts.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IAccount *pAccount = NULL;
	
	COleSafeArray sa(vAccounts);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)
		
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
		if (pAccount != NULL)
		{
			CString sAcctID;
			sAcctID.Format(L"%ld",pAccount->AccountID); 
			m_AcctList.AddString(sAcctID);
			pAccount->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}


